this.name			= "Wormhole Bomb";
this.author		= "Switeck";
this.licence		= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.copyright	= "(C) 2018 Switeck";
this.description	= "Wormhole-Generating Bomb creates a wormhole to your currently targeted system within 7 LY, destroying itself in the process.";
this.version		= "0.3.6 - for Oolite 1.75 and later";

"use strict";

this.spawned = function()
{
//	player.commsMessage("Wormhole Bomb jumping! "+this.ship.fuel,3);
	if(this.ship.fuel == 7) {
		this.ship.sendAIMessage("JUMPING");
		this.swi_wh_dest = player.ship.targetSystem;
//		player.commsMessage("Wormhole Bomb jumping to: "+this.swi_wh_dest+". system name "+System.systemNameForID(this.swi_wh_dest),3);
	} else {
		this.ship.sendAIMessage("BOOM");
//		player.commsMessage("Wormhole Bomb used up and EXPLODING!",3);
	}
}

this.jump_out = function()
{
//	player.commsMessage("Wormhole Bomb jumping! "+this.ship.fuel,3);
	if(this.ship.fuel == 7) {
// galaxyNumber has to be checked because distanceToSystem checks only work in the standard galaxyNumber=0-7 (Galaxy Charts 1-8)! Also doesn't work right from interstellar space!
	if(galaxyNumber >-1 && galaxyNumber <8 && !system.isInterstellarSpace) {
		var swi_wh_dis = Number(System.infoForSystem(galaxyNumber, system.ID).distanceToSystem(System.infoForSystem(galaxyNumber,this.swi_wh_dest)).toFixed(1));
	} else {
//		var swi_wh_dis = 6;
// Records current location's X and Y
//		var swiX = Number((player.ship.galaxyCoordinatesInLY.x).toFixed(0));
//		var swiY = Number((player.ship.galaxyCoordinatesInLY.y).toFixed(0));
		var swiX = Math.floor(player.ship.galaxyCoordinates.x);
		var swiY = Math.floor(player.ship.galaxyCoordinates.y);
// Destination X and Y!
//		var swiDX = Number((player.ship.cursorCoordinates.x).toFixed(0));
//		var swiDY = Number((player.ship.cursorCoordinates.y).toFixed(0));
		var swiDX = Math.floor(player.ship.cursorCoordinates.x);
		var swiDY = Math.floor(player.ship.cursorCoordinates.y);
// Computes the distance via delta-X, delta-Y calc.
//		var xDif = Math.floor(Math.abs(swiX - swiDX));
		var xDif =swiX - swiDX;
		var yDif = Math.floor(Math.abs(swiY - swiDY)*0.5);
		var swi_wh_dis = Number((0.4*Math.floor(Math.sqrt(xDif*xDif + yDif*yDif))).toFixed(1));
	}
	if(swi_wh_dis < 7 && system.ID != this.swi_wh_dest) {
		player.commsMessage("Wormhole Bomb jumping to: "+this.swi_wh_dest+". system name "+System.systemNameForID(this.swi_wh_dest)+" distance = "+swi_wh_dis+" LY.",5);
		log("Wormhole Bomb jumping to ",this.swi_wh_dest," system name ",System.systemNameForID(this.swi_wh_dest)," distance = ",swi_wh_dis," LY.");
		this.ship.exitSystem(this.swi_wh_dest);
	} else {
		player.commsMessage("Wormhole Bomb jumping to random nearby system from: "+system.ID,5);
		this.ship.exitSystem();
	}
	}
//	this.ship.fuel = 0;
//	player.commsMessage("Wormhole Bomb jumped.",3);
}
/*
Variable used:
	this.swi_wh_dest
	var swi_wh_dis
	var swiX, swiY
	var swiDX, swiDY
	var xDif, yDif
*/